
----------------------------------------------------------------------------
--StartMission Event
----------------------------------------------------------------------------
--
--
function eventStartMission(mission_name, persons_table, squad, cancel)

	--
	local log_id = M_INIT_LOG
	local squad_str = "squad"
	local actual_des = mission_name
	--
	log(log_id, "onStartMission:", string.upper(mission_name))
	--
	if ( (squad == nil) or (squad == 0) ) then
		--
		log(log_id, "ZERO SQUAD!")
		--
		return
	end
	--
	squad_str = "squad"..squad
	--
	local position = SQUADS_POSITIONS[squad_str]
	local destination = SQUADS_DESTINATIONS[squad_str]
	local isMoving = SQUAD_IS_MOVING[squad_str]
	--
	if ( isMoving == true ) then
		--
		log(log_id, "IMPOSSIBLE!", squad_str, "IS ALREADY MOVING SOMEWHERE ELSE")
		--
		return
		--
	end
	--
	if ( mission_name == position ) then
		--
		if ( isValid(destination) ) then
			--
			log(log_id, "CANCELING")
			--
			setDestination(squad, "")
			--
			return
			--
		end
		--
		log(log_id, "ENTERING SECTOR:", string.upper(mission_name))
		--
		setDestination(squad, "")
		--
		Spawn.spawned = 0
		CUR_MISSION.Mercs = persons_table
		--
		if ( mission_name ~= "drug_deal" ) then
			if ( (REVISITING[mission_name] == true) or (BATTLE_DATA.Enabled == true) )then
				activateSpawn(mission_name, PLAYER, "defence", true)
			elseif ( isValid(SQUADS_ENTRANCES[mission_name]) ) then
	--			REVISITING[mission_name] = true
				activateSpawn(actual_des, PLAYER, SQUADS_ENTRANCES[mission_name], true)
			else
	--			REVISITING[mission_name] = true
				if ((mission_name == "north_road") and (DEBUG == false)) then
					activateSpawn(mission_name, PLAYER, "west", true)
				else
					activateSpawn(mission_name, PLAYER, "north", true)
					activateSpawn(mission_name, PLAYER, "south", true)
					activateSpawn(mission_name, PLAYER, "west", true)
					activateSpawn(mission_name, PLAYER, "east", true)
				end
				
			end
		else
			activateSpawn(mission_name, PLAYER, "help_marauders", ((CURRENT_ALLY == MARAUDERS) or DEBUG))
			activateSpawn(mission_name, PLAYER, "help_army", (CURRENT_ALLY == ARMY))
		end
		--
		enterSector(mission_name, true)
		--
		return
		--
	end
	--
	local res = {}
	--
	if ( (cancel == true) and (destination == mission_name) ) then
		--
		log(log_id, "CANCELING")
		--
		setDestination(squad, "")
		--
		return
		--
	elseif ( (cancel == false) and (destination ~= mission_name) ) then
		--
		if ( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
			log(log_id, "HELICOPTER 1")
			local sectorToFight = mission_name
			local sectorToRetreat = position

			if (belongsToEnemy(PLAYER, mission_name) == false) then
				sectorToFight = ""
			end

			res = { found = true, path = Positions[position]..","..Positions[mission_name], time = HELICOPTER_TRAVEL_TIME, fight_sector = sectorToFight, retreat_sector = sectorToRetreat }
		else
			log(log_id, "NO HELICOPTER 1")
			res = findPath(PLAYER, position, mission_name)
		end
		--
		if ( isValid(res.fight_sector) ) then
			actual_des = res.fight_sector
		end
		if ( actual_des == destination ) then
			actual_des = mission_name
		end
		--
		log(log_id, "NEW DESTINATION:", string.upper(actual_des))
		--
		setDestination(squad, actual_des)
		--
		--return
		--
	end
	--
	log(log_id, "GOING TO SECTOR:", string.upper(actual_des))
	--
	
	if ( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
		log(log_id, "HELICOPTER 2")
		local sectorToFight = actual_des
		local sectorToRetreat = position

		if (belongsToEnemy(PLAYER, actual_des) == false) then
			sectorToFight = ""
		end

		res = { found = true, path = Positions[position]..","..Positions[actual_des], time = HELICOPTER_TRAVEL_TIME, fight_sector = sectorToFight, retreat_sector = sectorToRetreat }
	else
		log(log_id, "NO HELICOPTER 2")
		res = findPath(PLAYER, position, actual_des)
	end
		
	if ( res.found == false ) then
		log(log_id, "NO PATH")
		setDestination(squad, position)
		return
	end

	-- if path contains sector with enemies - interrupt it on this sector
	
	local action = "move"
	
	if ( isValid(res.fight_sector) ) then
		log(log_id, "ATTACK")
		setDestination(squad, res.fight_sector)
		actual_des = res.fight_sector
		action = "attack"
	else
		setDestination(squad, actual_des)
	end
	--
	REVISITING[position] = false
	REVISITING[actual_des] = false
	--
	setPosition(squad, "")
	--
	if ( res.retreat_sector ~= nil ) then
		SQUAD_RETREAT_POSITIONS[squad_str] = res.retreat_sector
		--
		log(log_id, res.retreat_sector, actual_des)
		--
		if ( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
			SQUADS_ENTRANCES[mission_name] = nil
		else
			SQUADS_ENTRANCES[actual_des] = Joints[res.retreat_sector][actual_des].entrance
			--sound2D("ui/misc/car_start")
		end
		--
		log(log_id, SQUADS_ENTRANCES[mission_name])
	end
	--
	SQUAD_IS_MOVING[squad_str] = true
	--
	if( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
		sound2D("ui/misc/helicopter_start")
	else
		sound2D("ui/misc/car_start")
	end

	startArmyMovement(squad_str, position, actual_des, action, res.path, res.time, true)
	--
	return
	--
end
--
--
--
--
--

